<Query Kind="Statements">
  <Namespace>System.Runtime.Serialization</Namespace>
  <Namespace>System.Text.Json</Namespace>
  <Namespace>System.Text.Json.Serialization</Namespace>
  <Namespace>System.Security.Cryptography</Namespace>
</Query>

byte[] data = Encoding.UTF8.GetBytes ("Wiadomość do podpisania");
byte[] publicKey;
byte[] signature;
object hasher = SHA1.Create();         // Wybrany przez nas algorytm haszowania

// generuje nową parę kluczy i podpisuje nią dane
using (var publicPrivate = new RSACryptoServiceProvider())
{
	signature = publicPrivate.SignData (data, hasher);
	publicKey = publicPrivate.ExportCspBlob (false);    // pobiera klucz publiczny
}

// tworzy nowy RSA przy użyciu samego klucza publicznego, a potem sprawdza podpis
using (var publicOnly = new RSACryptoServiceProvider())
{
	publicOnly.ImportCspBlob (publicKey);
	Console.WriteLine (publicOnly.VerifyData (data, hasher, signature)); // True

	// zmienimy dane i sprawdzimy podpis
	data [0] = 0;
	Console.WriteLine (publicOnly.VerifyData (data, hasher, signature)); // False

	// wyjątek, ponieważ nie mamy klucza prywatnego
	signature = publicOnly.SignData (data, hasher);
}